% demo_wiener

close all;
clear; 

Ioriginal = (imrotate(imread('Bella.jpg'),-90));
figure(1);
clf;
subplot(1,4,1);
imshow(Ioriginal);
title('Original');
pause;


PSF = fspecial('motion',161,41);
Idouble = im2double(Ioriginal);
blurred = imfilter(Idouble,PSF,'conv','circular');
figure(1);
%imshow(blurred);
%title('Motion Blurred')
%pause;

noise_mean = 0;
noise_var = 0.00001;
blurred_noisy = imnoise(blurred,'gaussian',noise_mean,noise_var);
subplot(1,4,2);
imshow(blurred_noisy);
title('Blurred and Noisy Image')
pause;

% wnr2 = deconvwnr(blurred_noisy,PSF);
% imshow(wnr2)
% %title('Restoration of Blurred Noisy Image (NSR = 0)')
% %pause;


signal_var = var(Idouble(:));
NSR = noise_var / signal_var;
wnr3 = deconvwnr(blurred_noisy,PSF,NSR);
subplot(1,4,3);
imshow(wnr3);
title('Wiener Filter');
%title('Restoration of Blurred Noisy Image (Estimated NSR)')
%pause;
pause;

addpath('deconvtv_v1/deconvtv_v1');

% Setup parameters (for example)
opts.rho_r   = 2;
opts.beta    = [1 1 0];
opts.print   = true;
opts.alpha   = 0.7;
opts.method  = 'l2';

% Setup mu
mu           = 10000;

% Main routine
tic
out = deconvtv(blurred_noisy, PSF, mu, opts);
toc

subplot(1,4,4);
imshow(out.f);
title('TV Minimization');
